#!/bin/sh

ACCTON_PLATFORM_MAP=${ACCTON_PLATFORM_TOP_DIR}/project_build_environment/${PROJECT_NAME}/fs/rootfs/usr/map

# clean up old map files
rm -f ${ACCTON_PLATFORM_MAP}/*

cd ${ACCTON_PLATFORM_TOP_DIR}/project_build_environment/${PROJECT_NAME}/prom/
make install
if [ $? != 0 ]; then
	echo "Error: make install diag failed."
	exit 1
fi

cd ${ACCTON_PLATFORM_TOP_DIR}/project_build_environment/${PROJECT_NAME}/user/
make install
if [ $? != 0 ]; then
	echo "Error: make install user failed."
	exit 1
fi

cd ${ACCTON_PLATFORM_TOP_DIR}/project_build_environment/${PROJECT_NAME}/cmnlib/
make install
if [ $? != 0 ]; then
	echo "Error: make install cmnlib failed."
	exit 1
fi

cd ${ACCTON_PLATFORM_TOP_DIR}/project_build_environment/${PROJECT_NAME}/fs/rootfs/usr/bin
FILES=`ls`
for file in $FILES
do
	${CROSS_COMPILE}nm -n --defined-only $file | grep -e " T " -e " t " >${ACCTON_PLATFORM_MAP}/${file}.map 
	# remove zero-length map file or linux kernel will get exception
	# when look up symbol from the map file
	if [ ! -s ${ACCTON_PLATFORM_MAP}/${file}.map ]; then
		rm ${ACCTON_PLATFORM_MAP}/${file}.map
	fi
done 

cd ${ACCTON_PLATFORM_TOP_DIR}/project_build_environment/${PROJECT_NAME}/fs/rootfs/usr/lib
FILES=`ls *.so.0.0.0`
for file in $FILES
do
	${CROSS_COMPILE}nm -n --defined-only $file | grep -e " T " -e " t " >${ACCTON_PLATFORM_MAP}/${file}.map 
	# remove zero-length map file or linux kernel will get exception
	# when look up symbol from the map file
	if [ ! -s ${ACCTON_PLATFORM_MAP}/${file}.map ]; then
		rm ${ACCTON_PLATFORM_MAP}/${file}.map
	fi
done 

exit 0
